//+------------------------------------------------------------------+
//|                                               Profit Manager.mq4 |
//|                                     Copyright  2012, Snoopy1234 |
//|                                                                  |
//+------------------------------------------------------------------+
#property copyright "Copyright  2012, Snoopy1234"
#property link      "www.snoopys-platz.de.tl"
#property show_inputs



#include <stdlib.mqh>

string gs_76 = "1.7";
string gs_84 = "Profit Manager";
extern double GlobalTakeProfit = 0.0;
extern double GlobalStopLoss = 0.0;
extern bool ResetTradeManager = FALSE;
extern bool ResetTrendManager = FALSE;
extern int MagicNumber = 9876;
extern bool ContinueAfterTP = TRUE;
extern bool ContinueAfterSL = TRUE;
extern bool LoadLastData = FALSE;
extern bool WriteToFile = TRUE;
extern int CloseRetries = 5;
extern bool ModifyOnFail = TRUE;
extern string FileName = "ProfitManager.csv";
extern bool DebugMode = FALSE;
bool gi_unused_156 = TRUE;
bool gi_160 = TRUE;
bool gi_unused_164 = TRUE;
bool gi_unused_168 = TRUE;
int gi_172 = 10;
int gi_176 = 16711680;
int gi_180 = 8388608;
int gi_184 = 15453831;
int gi_188 = 16777215;
color g_color_192;
int gi_196;
string gs_200;
string gs_208;
int gi_unused_216 = 0;
double gd_224;
double gd_232;
double gd_240;
double g_global_var_248;
double gd_256;
double gd_264;
double g_global_var_272 = 0.0;
double gd_280 = 999999.0;
int g_magic_288;
string gs_dummy_292;
bool gi_300 = TRUE;
bool gi_304;
string gs_unused_308;
bool gi_316 = FALSE;
int gi_320 = -1;
int gestartet = 0;
//+------------------------------------------------------------------+
//| expert initialization function                                   |
//+------------------------------------------------------------------+
int init()
  {
//----
   if (gestartet == 0) {
         gestartet = 1;
         run_script();
   }
//----
   return(0);
  }
//+------------------------------------------------------------------+
//| expert deinitialization function                                 |
//+------------------------------------------------------------------+
int deinit()
  {
//----
   
//----
   return(0);
  }
//+------------------------------------------------------------------+
//| expert start function                                            |
//+------------------------------------------------------------------+
int start()
  {
//----
   
//----
   return(0);
  }
//+------------------------------------------------------------------+


int run_script() {
   int li_12;
   int l_second_20;
   int li_28;
   string l_time2str_36;
   string l_time2str_44;
   int l_datetime_52;
   int l_datetime_60;
   bool li_0 = FALSE;
   int li_16 = 500;
   GlobalVariableSet("$EnableTrading", 1);
   checkUserAuth(1);
   if (!gi_304) {
      Alert("Profit Manager >>> Invalid Account! IsDemo()=" + Bool2Text(IsDemo()));
      return;
   }
   if (GlobalTakeProfit < 0.0) {
      Alert("Profit Manager >>> Take Profit must be greater than 0!");
      GlobalTakeProfit = 0;
   }
   if (GlobalStopLoss > 0.0) {
      Alert("Profit Manager >>> Stop Loss must be less than 0!");
      GlobalStopLoss = 0;
   }
   if (gi_160) {
      g_color_192 = gi_184;
      gi_196 = gi_188;
   } else {
      g_color_192 = gi_176;
      gi_196 = gi_180;
   }
   if (LoadLastData) {
      if (GlobalVariableCheck("PMBalance" + MagicNumber)) g_global_var_248 = GlobalVariableGet("PMBalance" + MagicNumber);
      if (GlobalVariableCheck("PMGTakeProfit" + MagicNumber)) GlobalTakeProfit = GlobalVariableGet("PMGTakeProfit" + MagicNumber);
      if (GlobalVariableCheck("PMGStopLoss" + MagicNumber)) GlobalStopLoss = GlobalVariableGet("PMGStopLoss" + MagicNumber);
      if (GlobalVariableCheck("PMDrawDown" + MagicNumber)) g_global_var_272 = GlobalVariableGet("PMDrawDown" + MagicNumber);
      if (GlobalVariableCheck("PMLowFree" + MagicNumber)) gd_280 = GlobalVariableGet("PMLowFree" + MagicNumber);
      if (GlobalVariableCheck("PMOnProfitResetTrade" + MagicNumber)) ResetTradeManager = GlobalVariableGet("PMOnProfitResetTrade" + MagicNumber);
      if (GlobalVariableCheck("PMOnProfitResetTrend" + MagicNumber)) ResetTrendManager = GlobalVariableGet("PMOnProfitResetTrend" + MagicNumber);
   } else g_global_var_248 = AccountBalance(); //Edited
   ObjectCreate("cashTime", OBJ_LABEL, 0, 0, 0);
   ObjectSet("cashTime", OBJPROP_CORNER, 0);
   ObjectSet("cashTime", OBJPROP_XDISTANCE, 5);
   ObjectSet("cashTime", OBJPROP_YDISTANCE, 20);
   while (!li_0) {
      li_28 = 3;
      l_datetime_52 = TimeLocal();
      l_datetime_60 = TimeCurrent();
      l_time2str_36 = TimeToStr(l_datetime_52, TIME_SECONDS);
      l_time2str_44 = TimeToStr(l_datetime_60, TIME_SECONDS);
      l_second_20 = TimeSeconds(l_datetime_52);
      ObjectSetText("cashTime", gs_84 + " - " + gs_76 + " >> " + l_time2str_36, 12, "Arial Bold", g_color_192);
      stats();
      if (gd_240 < g_global_var_272) g_global_var_272 = gd_240;
      if (AccountFreeMargin() < gd_280) gd_280 = AccountFreeMargin();
      AdvancedComment(gi_300, 0, li_28, "ContinueAfterTP", Bool2Text(ContinueAfterTP), g_color_192, gi_196, gi_172, gs_200, gs_208);
      li_28++;
      AdvancedComment(gi_300, 0, li_28, "ContinueAfterSL", Bool2Text(ContinueAfterSL), g_color_192, gi_196, gi_172, gs_200, gs_208);
      li_28++;
      AdvancedComment(gi_300, 0, li_28, "Global TP", DoubleToStr(GlobalTakeProfit, 2), g_color_192, gi_196, gi_172, gs_200, gs_208);
      li_28++;
      AdvancedComment(gi_300, 0, li_28, "Global SL", DoubleToStr(GlobalStopLoss, 2), g_color_192, gi_196, gi_172, gs_200, gs_208);
      li_28++;
      li_28++;
      AdvancedComment(gi_300, 0, li_28, "Snap Shot", DoubleToStr(g_global_var_248, 2), g_color_192, gi_196, gi_172, gs_200, gs_208);
      li_28++;
      AdvancedComment(gi_300, 0, li_28, "Snap Profit", DoubleToStr(gd_240, 2), g_color_192, gi_196, gi_172, gs_200, gs_208);
      li_28++;
      AdvancedComment(gi_300, 0, li_28, "Equity DD", DoubleToStr(g_global_var_272, 2), g_color_192, gi_196, gi_172, gs_200, gs_208);
      li_28++;
      AdvancedComment(gi_300, 0, li_28, "Percent DD", DoubleToStr(gd_256, 2), g_color_192, gi_196, gi_172, gs_200, gs_208);
      li_28++;
      AdvancedComment(gi_300, 0, li_28, "Lowest % DD", DoubleToStr(gd_264, 2), g_color_192, gi_196, gi_172, gs_200, gs_208);
      li_28++;
      li_28++;
      AdvancedComment(gi_300, 0, li_28, "Free Margin", DoubleToStr(AccountFreeMargin(), 2), g_color_192, gi_196, gi_172, gs_200, gs_208);
      li_28++;
      AdvancedComment(gi_300, 0, li_28, "Lowest Free", DoubleToStr(gd_280, 2), g_color_192, gi_196, gi_172, gs_200, gs_208);
      li_28++;
      GlobalVariableSet("$EnableTrading", 1);
      if ((gd_240 > GlobalTakeProfit && GlobalTakeProfit != 0.0) || (gd_240 < GlobalStopLoss && GlobalStopLoss != 0.0)) {
         Print("Closing Basket!");
         if (!CloseBasket()) {
            Alert("Basket closed out with Snap Profit: $ " + DoubleToStr(gd_240, 2) + " TP: " + DoubleToStr(GlobalTakeProfit, 2) + DoubleToStr(GlobalStopLoss, 2) + " Snap: " +
               DoubleToStr(g_global_var_248, 2) + " New Equity: " + DoubleToStr(AccountEquity(), 2));
            if (!ContinueAfterTP && (gd_240 > GlobalTakeProfit && GlobalTakeProfit != 0.0)) {
               li_12 = ObjectFind("cashTime");
               GlobalVariableSet("$EnableTrading", 0);
               return (0);
            }
            if (!ContinueAfterSL && (gd_240 < GlobalStopLoss && GlobalStopLoss != 0.0)) {
               li_12 = ObjectFind("cashTime");
               GlobalVariableSet("$EnableTrading", 0);
               return (0);
            }
            if (ResetTradeManager) GlobalVariableSet("$TradeManagerReset", 1);
            if (ResetTrendManager) GlobalVariableSet("$TrendManagerReset", 1);
            if (WriteToFile) writeLineToFile();
            g_global_var_248 = AccountEquity();
            g_global_var_272 = 0;
            gd_264 = 0;
            gd_256 = 0;
            gd_280 = AccountFreeMargin();
         } else Alert("Basket closed out ERROR @ $" + DoubleToStr(gd_240, 2));
         gi_300 = FALSE;
      }
      ObjectsRedraw();
      GlobalVariableSet("PMBalance" + MagicNumber, g_global_var_248);
      GlobalVariableSet("PMGTakeProfit" + MagicNumber, GlobalTakeProfit);
      GlobalVariableSet("PMGStopLoss" + MagicNumber, GlobalStopLoss);
      GlobalVariableSet("PMDrawDown" + MagicNumber, g_global_var_272);
      GlobalVariableSet("PMLowFree" + MagicNumber, gd_240);
      GlobalVariableSet("PMOnProfitResetTrade" + MagicNumber, ResetTradeManager);
      GlobalVariableSet("PMOnProfitResetTrend" + MagicNumber, ResetTrendManager);
      Sleep(li_16);
   }
   return (0);
}

int stats() {
   int l_ord_total_4 = OrdersTotal();
   gd_232 = 0;
   gd_224 = 0;
   gd_240 = AccountEquity() - g_global_var_248;
   for (int l_pos_0 = l_ord_total_4 - 1; l_pos_0 >= 0; l_pos_0--) {
      if (OrderSelect(l_pos_0, SELECT_BY_POS, MODE_TRADES)) {
         if (OrderSymbol() == Symbol() && OrderMagicNumber() == g_magic_288) {
            gd_232 += OrderProfit();
            if (OrderType() == OP_BUY) gd_224 += (Bid - OrderOpenPrice()) / Point;
            else
               if (OrderType() == OP_SELL) gd_224 += (OrderOpenPrice() - Ask) / Point;
         }
      }
   }
   gd_256 = 100.0 * (g_global_var_272 / g_global_var_248);
   if (gd_256 < gd_264) gd_264 = gd_256;
   return (0);
}

void checkUserAuth(int ai_0) {
/*   if (IsDemo()) {
      gs_unused_308 = "DEMO";
      gi_304 = TRUE;
      return;
   }
   string l_acc_number_4 = AccountNumber();
   string l_str_concat_12 = StringConcatenate("p", l_acc_number_4);
   if (QuickCheck("ftp.powertradeliveauth.com", l_str_concat_12, AccountNumber(), ai_0)) {*/
      gs_unused_308 = "LIVE";
      gi_304 = TRUE;
/*      return;
   }
   gs_unused_308 = "INVALID";
   gi_304 = FALSE;*/
}

bool CloseBasket() {
   int l_count_16;
   int l_cmd_20;
   int l_error_24;
   string ls_unused_32;
   bool l_bool_44;
   int li_28 = 100;
   int l_ord_total_12 = OrdersTotal();
   for (int l_pos_4 = l_ord_total_12 - 1; l_pos_4 >= 0; l_pos_4--) {
      if (OrderSelect(l_pos_4, SELECT_BY_POS, MODE_TRADES)) {
         l_count_16 = 0;
         l_cmd_20 = OrderType();
         while (l_count_16 < CloseRetries) {
            switch (l_cmd_20) {
            case OP_BUY:
               RefreshRates();
               Print("CLOSEBASKET: Closing ", l_pos_4, " ", l_count_16, " ", l_cmd_20, " ", OrderSymbol(), " ", OrderClosePrice());
               OrderClose(OrderTicket(), OrderLots(), OrderClosePrice(), 0, White);
               break;
            case OP_SELL:
               RefreshRates();
               Print("CLOSEBASKET: Closing ", l_pos_4, " ", l_count_16, " ", l_cmd_20, " ", OrderSymbol(), " ", OrderClosePrice());
               OrderClose(OrderTicket(), OrderLots(), OrderClosePrice(), 0, White);
               break;
            case OP_BUYLIMIT:
            case OP_BUYSTOP:
            case OP_SELLLIMIT:
            case OP_SELLSTOP:
               Print("CLOSEBASKET: Deleting ", l_pos_4, " ", l_count_16, " ", l_cmd_20, " ", OrderSymbol());
               OrderDelete(OrderTicket());
            }
            l_error_24 = GetLastError();
            if (l_error_24 != 0/* NO_ERROR */) {
               Print("CloseBasket - " + Symbol() + " " + ErrorDescription(l_error_24));
               if (l_count_16 + 1 < CloseRetries) Sleep(li_28);
               else {
                  if (ModifyOnFail) {
                     RefreshRates();
                     if (OrderType() == OP_BUY) l_bool_44 = OrderModify(OrderTicket(), OrderOpenPrice(), Bid - MarketInfo(OrderSymbol(), MODE_STOPLEVEL) * Point, Bid + MarketInfo(OrderSymbol(), MODE_POINT) * Point, 0);
                     else
                        if (OrderType() == OP_SELL) l_bool_44 = OrderModify(OrderTicket(), OrderOpenPrice(), Ask + MarketInfo(OrderSymbol(), MODE_STOPLEVEL) * Point, Ask - MarketInfo(OrderSymbol(), MODE_POINT) * Point, 0);
                     if (!l_bool_44) {
                        l_error_24 = GetLastError();
                        Print("Modify Failed - " + Symbol() + " " + ErrorDescription(l_error_24));
                     } else Print("Modify succeeded.");
                  }
               }
            } else l_count_16 = CloseRetries;
            l_count_16++;
         }
      } else {
         Print("CloseBasket Order Select -" + Symbol() + " " + ErrorDescription(GetLastError()));
         break;
      }
   }
   return (l_error_24);
}

int AdvancedComment(bool ai_0, int a_corner_4, int ai_8, string a_text_12, string a_text_20, color a_color_28, color a_color_32, int ai_36, string a_fontname_40, string a_fontname_48) {
   int l_fontsize_64;
   int l_x_76;
   int l_x_80;
   int li_56 = 10;
   int l_fontsize_60 = 10;
   int li_68 = 15;
   if (ai_36 > li_56) l_fontsize_64 = ai_36;
   else l_fontsize_64 = li_56;
   l_fontsize_60 = l_fontsize_64;
   if (a_corner_4 == 0 || a_corner_4 == 2) {
      l_x_76 = 5;
      l_x_80 = 100;
   } else {
      l_x_76 = 70;
      l_x_80 = 5;
   }
   int l_y_72 = ai_8 * li_68;
   if (ai_0) {
      ObjectDelete("PanelLabel" + ai_8 + a_corner_4);
      ObjectCreate("PanelLabel" + ai_8 + a_corner_4, OBJ_LABEL, 0, 0, 0);
      ObjectSetText("PanelLabel" + ai_8 + a_corner_4, a_text_12, l_fontsize_60, a_fontname_40, a_color_28);
      ObjectSet("PanelLabel" + ai_8 + a_corner_4, OBJPROP_CORNER, a_corner_4);
      ObjectSet("PanelLabel" + ai_8 + a_corner_4, OBJPROP_XDISTANCE, l_x_76);
      ObjectSet("PanelLabel" + ai_8 + a_corner_4, OBJPROP_YDISTANCE, l_y_72);
      ObjectDelete("PanelData" + ai_8 + a_corner_4);
      ObjectCreate("PanelData" + ai_8 + a_corner_4, OBJ_LABEL, 0, 0, 0);
      ObjectSet("PanelData" + ai_8 + a_corner_4, OBJPROP_CORNER, a_corner_4);
      ObjectSet("PanelData" + ai_8 + a_corner_4, OBJPROP_XDISTANCE, l_x_80);
      ObjectSet("PanelData" + ai_8 + a_corner_4, OBJPROP_YDISTANCE, l_y_72);
   }
   ObjectSetText("PanelData" + ai_8 + a_corner_4, a_text_20, l_fontsize_64, a_fontname_48, a_color_32);
   return (0);
}

string Bool2Text(bool ai_0) {
   if (ai_0) return ("TRUE");
   else return ("FALSE");
}
/*
bool QuickCheck(string as_0, string as_8, string as_16, bool ai_24) {
   string ls_28;
   int l_str2int_36 = StrToInteger(as_8);
   int li_40 = l_str2int_36 & 768 / 255 + 1;
   int li_44 = l_str2int_36 & 240 / 16 + 1;
   int li_48 = l_str2int_36 & 15;
   string l_var_name_52 = as_8;
   if (GlobalVariableCheck(l_var_name_52)) gi_320 = GlobalVariableGet(l_var_name_52);
   else GlobalVariableSet(l_var_name_52, -1);
   if (ai_24) {
      ls_28 = gConnect(as_0, as_8, as_16, "ROOT");
      if (ls_28 == "Connected") gi_316 = TRUE;
      else gi_316 = FALSE;
      GlobalVariableSet(l_var_name_52, DayOfWeek());
   } else {
      if (li_40 == DayOfWeek() && li_44 == Hour() && li_48 == Minute()) {
         if (gi_320 != DayOfWeek()) {
            ls_28 = gConnect(as_0, as_8, as_16, "ROOT");
            if (ls_28 == "Connected") gi_316 = TRUE;
            else gi_316 = FALSE;
         }
         GlobalVariableSet(l_var_name_52, DayOfWeek());
      }
   }
   return (gi_316);
}
*/
void writeLineToFile() {
   string ls_0;
   int l_file_8 = FileOpen(FileName, FILE_WRITE|FILE_READ);
   if (l_file_8 >= 0) {
      FileSeek(l_file_8, 0, SEEK_END);
      ls_0 = TimeMonth(TimeCurrent()) + "/" + TimeDay(TimeCurrent()) + "/" + TimeYear(TimeCurrent()) + " " + TimeHour(TimeCurrent()) + ":" + TimeMinute(TimeCurrent()) + ":" + TimeSeconds(TimeCurrent()) + "," + TimeCurrent() + "," + DoubleToStr(GlobalTakeProfit, 2) + "," + DoubleToStr(GlobalStopLoss, 2) + "," + DoubleToStr(g_global_var_248, 2) + "," + DoubleToStr(gd_240, 2) + "," + DoubleToStr(g_global_var_272, 2) + "," + DoubleToStr(gd_256, 2) + "," + DoubleToStr(gd_264, 2) + "," + DoubleToStr(AccountFreeMargin(), 2) + "," + DoubleToStr(gd_280, 2) + "," + DoubleToStr(AccountEquity(), 2);
      FileWrite(l_file_8, ls_0);
      FileFlush(l_file_8);
      FileClose(l_file_8);
      return;
   }
   Print("Error opening file: " + FileName + " for XML output!");
}